let currentIndex = 0;
const slides = document.querySelector('.slides');
const totalSlides = document.querySelectorAll('.slide').length;
const intervalTime = 9000; // 9 seconds

document.querySelector('.next').addEventListener('click', nextSlide);
document.querySelector('.prev').addEventListener('click', prevSlide);

// Function to show the next slide
function nextSlide() {
    if (currentIndex < totalSlides - 1) {
        currentIndex++;
    } else {
        currentIndex = 0; // Go back to the first slide
    }
    updateSlidePosition();
}

// Function to show the previous slide
function prevSlide() {
    if (currentIndex > 0) {
        currentIndex--;
    } else {
        currentIndex = totalSlides - 1; // Go to the last slide
    }
    updateSlidePosition();
}

// Function to update the position of the slide
function updateSlidePosition() {
    slides.style.transform = `translateX(-${currentIndex * 100}%)`;
}

// Automatically move to the next slide
setInterval(() => {
    nextSlide();
}, intervalTime);

nextSlide();





document.addEventListener('DOMContentLoaded', function () {
    const slider = document.querySelector('.slider');
    const slidesContainer = document.querySelector('.slides');
    const slideContainers = document.querySelectorAll('.slide-container');
    const totalSlides = slideContainers.length;
    
    const visibleSlides = Math.ceil(1 / 0.27); // 1 / 27% to get the number of visible slides in the viewport
    const offset = 3; // Number of slides to clone on each side (adjust this value to fine-tune)
    const slideWidth = slideContainers[0].clientWidth; // Assumes all slides are the same width

    // Clone slides at the start and end for seamless loop
    for (let i = 0; i < offset; i++) {
        const firstSlide = slideContainers[i].cloneNode(true);
        const lastSlide = slideContainers[totalSlides - 1 - i].cloneNode(true);
        slidesContainer.appendChild(firstSlide);
        slidesContainer.insertBefore(lastSlide, slideContainers[0]);
    }

    let currentSlide = offset; // Start after the cloned last slides
    const totalSlidesWithClones = totalSlides + 2 * offset; // Account for cloned slides

    // Set initial position
    slidesContainer.style.transform = `translateX(${-slideWidth * currentSlide}px)`;

    function moveToNextSlide() {
        if (currentSlide >= totalSlides + offset) {
            slidesContainer.style.transition = 'none';
            currentSlide = offset; // Loop back to the first real slide
            slidesContainer.style.transform = `translateX(${-slideWidth * currentSlide}px)`;
        }

        setTimeout(() => {
            slidesContainer.style.transition = 'transform 2s linear';
            currentSlide++;
            slidesContainer.style.transform = `translateX(${-slideWidth * currentSlide}px)`;
        }, 50);
    }

    // Start auto-scrolling
    setInterval(moveToNextSlide, 2000); // Adjust time interval as needed

    // Handle seamless looping
    slidesContainer.addEventListener('transitionend', () => {
        if (currentSlide === totalSlides + offset) {
            slidesContainer.style.transition = 'none';
            currentSlide = 0;
            slidesContainer.style.transform = `translateX(-130px)`;
            moveToNextSlide();
        }
    });
});